// Washing Machine Toy by MagicManu
// 12/2016
// Video on https://youtu.be/nIPeU1Od5qg
// http://blog.magicmanu.com

// 74HC595 for 2x 7 segments display
int outLatch= 4;
int outClk = 3;
int outData = 2;
byte digit[10] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F};  // 0 1 2 3 4 5 6 7 8 9
byte txtName[8] = {0x00, 0x39, 0x3F, 0x38, 0x72, 0x37, 0x79, 0x00};             // COLYNE
//byte txtName[6] = {0x00, 0x37, 0x3F, 0x77, 0x76, 0x00};                         // NOAH
int digitOne = 0x00;  // Value on digit 1
int digitTwo = 0x00;  // Value on digit 2
int Timer = 0;        // Current timer on display
int Aff = 0;          // Display
int i = 0;            // Index of digit 2
int j = 0;            // Index of digit 1

// L298 Motor Module
int outMot1 = 7;     // CW
int outMot2 = 8;     // CCW
int outSpeed = 6;    // PWM output
int PWM_val = 0;     // Power value
bool Dir1 = LOW;
bool Dir2 = LOW;

// Button
int InButton = 12;
bool LastButtonState = LOW;

// Buzzer
int outBuzzer = 11;

// Door switch
int InDoor = 9;
long TimeRefDoor = 0;  // Time at the open of the door
bool DoorOpen;

long TimeRefSeconde = 0;  // Time at the start of a new seconde
long CptSeconde = 0;      // Counter of seconde   

long TimeRefAcc = 0;  // Time at the start for acceleration
int CptAcc = 0;       // Counter of acceleration         

long TimeRefDir = 0;  // Time at the start for direction
int CptDir = 0;       // Counter of direction     

bool Ready = LOW;     // Ready after show lastname on display
bool MemoStop = HIGH;


void setup(){
  // 74HC595 for 2x 7 segments display
  pinMode(outLatch, OUTPUT);
  pinMode(outClk, OUTPUT);
  pinMode(outData, OUTPUT);
  
  // L298 Motor Module
  pinMode(outMot1, OUTPUT);
  pinMode(outMot2, OUTPUT);
  pinMode(outSpeed, OUTPUT);  
  
  // Button
  pinMode(InButton, INPUT_PULLUP);
  
  // Door
  pinMode(InDoor, INPUT_PULLUP);
  
  // Buzzer
  pinMode(outBuzzer, OUTPUT);
  
  // Show lastname of child on startup
  for (int i=1; i<sizeof(txtName); i++){
    digitalWrite(outLatch, LOW);
    shiftOut(outData, outClk, MSBFIRST, txtName[i]);
    shiftOut(outData, outClk, MSBFIRST, txtName[i-1]);
    digitalWrite(outLatch, HIGH);
    delay(500);
  } 
 
  tone(outBuzzer, 3000, 200);
  Ready = HIGH;
}

void loop(){
  
  if (!Ready) return;
  
  int ButtonState = !digitalRead(InButton);  
  int DoorState = digitalRead(InDoor);  
  
  // Door open > STOP
  if (DoorState){
    Timer = 0;
    analogWrite(outSpeed, 0); // Force immediately stop
    TimeRefDoor = millis();
  }
  DoorOpen = millis() - TimeRefDoor < 50;

    
  // STOP
  if (Timer <= 0){
    PWM_val = 0;
    Dir1 = LOW;
    Dir2 = LOW;
    
    // Final melody
    if (!MemoStop){
      tone(outBuzzer, 1500);
      delay(300);
      tone(outBuzzer, 1200);
      delay(300);
      tone(outBuzzer, 900);
      delay(300);
      tone(outBuzzer, 600);
      delay(800);
      noTone(outBuzzer);
      
      MemoStop = HIGH;
    }
        
  }
    
  // Command of the motor  
  analogWrite(outSpeed, PWM_val);
  digitalWrite(outMot1, Dir1);
  digitalWrite(outMot2, Dir2);
  
  CptDir = millis() - TimeRefDir;


  // Reverse direction every 10 sec
  if (CptDir > 10000){
    
    // Deceleration
    PWM_val = 0;
      
    if (CptDir > 10500){    
      Dir1 = !Dir1;
      Dir2 = !Dir1;  
      TimeRefAcc = millis();  
      TimeRefDir = millis();
    }  
  }
  else{
    // Acceleration
    CptAcc = millis() - TimeRefAcc;    
    PWM_val = CptAcc / 10;
    if (PWM_val > 255)
      PWM_val = 255;      
  }

  
  // Start button pressed
  if (ButtonState != LastButtonState){
    if (DoorOpen)
      tone(outBuzzer, 300, 400);  // Error bip if door is open
    else if (ButtonState){
      
      // Bip
      tone(outBuzzer, 3000, 200);

      // START
      if (Timer == 0){
        TimeRefAcc = millis();  
        TimeRefDir = millis();   
        Dir1 = HIGH;
        Dir2 = LOW;     
        MemoStop = LOW;
      }
      
      Timer += 10;    // Increment timer
      if (Timer > 60)
        Timer = 60;
        
      TimeRefSeconde = millis();
    }
    LastButtonState = ButtonState;
  }


  // Decrements
  CptSeconde = millis() - TimeRefSeconde;
  if (Timer > 0 && CptSeconde > 1000){
    Timer--;
    TimeRefSeconde = millis();
  }
  
  // Auto power off after 5 minutes
  if (CptSeconde > 350000){
    digitOne = 0x00;
    digitTwo = 0x00;
  }
  // PO = Porte Ouverte (Door Open)
  else if (DoorOpen){
    digitOne = 0x73;
    digitTwo = 0x3F;
  }  
  // Current value display
  else{
    Aff = int(Timer);
    j = int(Aff / 10);
    i = Aff - (j * 10);
    digitTwo = digit[i];
    digitOne = digit[j];
  }
  
  // Display
  digitalWrite(outLatch, LOW);
  shiftOut(outData, outClk, MSBFIRST, digitTwo);
  shiftOut(outData, outClk, MSBFIRST, digitOne);
  digitalWrite(outLatch, HIGH);
}
